definition module link_switches

import StdDynamicTypes
import what_linker
// --------------------------
// switches for static linker

// switch dynamics (only if Link Method is set to eager):
// False		- create an executable and a complement
// True			- create a .lib and a .typ file 
dynamics :== True;

// switch for input/output
debug_static_linker normal_mode debug_mode :== normal_mode;

debug_dump_dynamic normal debug :== normal;

// ---------------------------
// switches for dynamic linker
test_dynamic_linker :== True

ALLOW_LAZY_LIBRARY_REFERENCES yes no :== yes;

ALLOW_UNUSED_UNDEFINED_SYMBOLS yes no :== yes;

CHOOSE_TYPE_REF_IN_LIBRARY_INSTANCE_TABLE eager lazy
	:== choose_type_ref_in_library_instance_table eager lazy
where
	choose_type_ref_in_library_instance_table eager lazy
		| IS_COLLECT_AND_RENUMBER_EXTERNAL_TYPE_REFERENCES
			= eager // or lazy

			// not correctly implemented, that's why IS_COLLECT_AND_RENUMBER_EXTERNAL_TYPE_REFERENCES
			// has been implemented.
		    = lazy /* do not change */

OUTPUT_UNIMPLEMENTED_FEATURES_WARNINGS yes no :== no;

DEBUG_INFO yes no :== (what_linker yes no);

ALLOW_LIBRARY_REDIRECTIONS yes no :== yes;

MAKE_INTERNAL_TYPES_USE_SINGLE_IMPLEMENTATION yes no :== yes;

USE_ENTER_NEW_TYPE_EQUATIONS yes no :== yes;

COLLECT_CONTEXT_TYPES yes no :== yes;

COLLECTING_CONTEXT_TYPES :== COLLECT_CONTEXT_TYPES True False;

USE_NEW_SCOPE_RESOLUTION_METHOD yes no :== yes;					// if this work, scope searching can be removed from type_io_static.icl

TEXT_DUMP_DYNAMIC yes no :== no;

IS_TEXT_DUMP_DYNAMIC :== TEXT_DUMP_DYNAMIC True False;

CONSTRUCTOR_SHARING yes no :== yes;

IS_CONSTRUCTOR_SHARING :== CONSTRUCTOR_SHARING True False;

SAFETY_CHECK yes no :== yes;

USE_SAFETY_CHECK :== SAFETY_CHECK True False;

ENABLE_DYNAMIC_LINKER_GUI yes no :== yes;